<?php

use Erlage\Photogram\SystemDebugger;

/*
|--------------------------------------------------------------------------
| decalare constants that can be used in config
|--------------------------------------------------------------------------
*/

const DATABASE_TYPE_MYSQL = 'MySQL';
const DATABASE_TYPE_MARIA_DB = 'MariaDB';
const DATABASE_TYPE_POSTGRESQL = 'PostgreSQL';

/*
|--------------------------------------------------------------------------
| load config
|--------------------------------------------------------------------------
*/

require __DIR__ . '/config.php';

/*
|--------------------------------------------------------------------------
| file system details
|--------------------------------------------------------------------------
*/

require __DIR__ . '/file_system.php';

/*
|--------------------------------------------------------------------------
| register autoloader
|--------------------------------------------------------------------------
*/

require DIR_PATH_ROOT . 'vendor/autoload.php';

/*
|--------------------------------------------------------------------------
| Debugger(it also suppress error, warnings etc by default)
|--------------------------------------------------------------------------
*/

require DIR_PATH_LIB . 'Tracy/tracy.php';

SystemDebugger::init();

/*
|--------------------------------------------------------------------------
| import redbean orm lib:
|--------------------------------------------------------------------------
*/

require DIR_PATH_LIB . 'RedBeanPHP/rb.php';

/*
|--------------------------------------------------------------------------
| parse url
|--------------------------------------------------------------------------
*/

$serverScheme = \parse_url(INSTALLATION_URL, PHP_URL_SCHEME) ?? 'http';
$serverHost = \parse_url(INSTALLATION_URL, PHP_URL_HOST) ?? 'localhost';
$serverPath = \parse_url(INSTALLATION_URL, PHP_URL_PATH) ?? '';

/*
|--------------------------------------------------------------------------
| set domain part(must not contain trailing slash)
|--------------------------------------------------------------------------
*/

$serverDomainName = "{$serverScheme}://{$serverHost}";

// ensure trailing slash is absent

if (\substr($serverDomainName, -1) === '/')
{
    $serverDomainName = \substr($serverDomainName, 0, -1);
}

\define('SERVER_DOMAIN_NAME', $serverDomainName);

/*
|--------------------------------------------------------------------------
| set domain path(must contain a leading slash but not trailing)
|--------------------------------------------------------------------------
*/

// if non-empty
if (\strlen($serverPath) > 0)
{
    // ensure leading slash is present

    if ( ! \substr($serverPath, 0, 1) === '/')
    {
        $serverPath = '/' . $serverPath;
    }

    // ensure trailing slash is absent

    if (\substr($serverPath, -1) === '/')
    {
        $serverPath = \substr($serverPath, 0, -1);
    }
}

\define('SERVER_DOMAIN_PATH', $serverPath);

/*
|--------------------------------------------------------------------------
| set urls
|--------------------------------------------------------------------------
*/

\define('SERVER_URL', SERVER_DOMAIN_NAME . SERVER_DOMAIN_PATH . DIRECTORY_SEPARATOR);

\define('ADMIN_CLIENT_PATH', SERVER_DOMAIN_PATH . DIRECTORY_SEPARATOR . ADMIN_CLIENT_DIR_NAME);
